% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dist.ind.snp.r
\name{utils.dist.ind.snp}
\alias{utils.dist.ind.snp}
\title{Calculates a distance matrix for individuals defined in a dartR
genlight object using SNP data (DArTseq)}
\usage{
utils.dist.ind.snp(
  x,
  method = "Euclidean",
  scale = FALSE,
  output = "dist",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight containing the genotypes [required].}

\item{method}{Specify distance measure [default Euclidean].}

\item{scale}{If TRUE and method='Euclidean', the distance will be scaled to 
fall in the range [0,1] [default FALSE].}

\item{output}{Specify the format and class of the object to be returned, 
dist for a object of class dist, matrix for an object of class matrix [default "dist"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default 2].}
}
\value{
An object of class 'dist' or 'matrix' giving distances between individuals
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
This script calculates various distances between individuals based on 
SNP genotypes.
The distance measure can be one of:
 \itemize{
  \item Euclidean -- Euclidean Distance applied to Cartesian coordinates defined
  by the loci, scored as 0, 1 or 2. 
 \item Simple -- simple mismatch, 0 where no alleles are shared, 1 where one
 allele is shared, 2 where both alleles are shared. 
 \item Absolute -- absolute mismatch, 0 where no alleles are shared, 1 where
 one or both alleles are shared.
 \item Czekanowski (or Manhattan) calculates the city block metric distance
 by summing the scores on each axis (locus).
 }
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()}
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{utilities}
