% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.edit.recode.pop.r
\name{gl.edit.recode.pop}
\alias{gl.edit.recode.pop}
\title{Create or edit a population re-assignment table}
\usage{
gl.edit.recode.pop(gl, pop.recode = NULL, recalc = FALSE,
  mono.rm = TRUE, v = 1)
}
\arguments{
\item{gl}{Name of the genlight object for which populations are to be reassigned.[required]}

\item{pop.recode}{Name of the file to output the new assignments [optional]}

\item{recalc}{-- Recalculate the locus metadata statistics if any individuals are deleted [default TRUE]}

\item{mono.rm}{-- Remove monomorphic loci [default TRUE]}

\item{v}{-- verbosity: 0, silent; 1, brief; 2, verbose [default 1]}
}
\value{
An object of class ("genlight") with the revised population assignments
}
\description{
A script to edit population assignments in a genlight object, or to 
create a reassignment table taking the population assignments
from a genlight object, or to edit existing population assignments in
a pop.recode.table.
}
\details{
Genlight objects assign specimens to populations based on information in the
ind.metadata file provided when the genlight object is first generated.
Often one wishes to subset the data by deleting populations or to amalgamate
populations. This can be done with a pop.recode table with two columns. The
first column is the population assignment in the genlight object, the second
column provides the new assignment.

This script will input an existing reassignment table for editting and
optionally save it as a new table, or if the name of an input table is not
supplied, will generate a table using the population assignments in the 
parent genlight object.

The script, having deleted populations, optionally identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r). The script also optionally
recalculates statistics made redundant by the deletion of individuals from the dataset.

The script returns a genlight object with the new population assignments and the recalculated locus metadata.
}
\examples{
\donttest{
gl <- gl.edit.recode.pop(testset.gl)
}
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
