% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.grm.network.r
\name{gl.grm.network}
\alias{gl.grm.network}
\title{Represents a genomic relationship matrix (GRM) as a network}
\usage{
gl.grm.network(
  G,
  x,
  method = "fr",
  node.size = 6,
  node.label = TRUE,
  node.label.size = 2,
  node.label.color = "black",
  relatedness_factor = 0.25,
  title = "Network based on a genomic relationship matrix",
  palette_discrete = discrete_palette,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{G}{A genomic relationship matrix (GRM) generated by
\code{\link{gl.grm}} [required].}

\item{x}{A genlight object from which the G matrix was generated [required].}

\item{method}{One of 'fr', 'kk', 'gh' or 'mds' [default 'fr'].}

\item{node.size}{Size of the symbols for the network nodes [default 6].}

\item{node.label}{TRUE to display node labels [default TRUE].}

\item{node.label.size}{Size of the node labels [default 3].}

\item{node.label.color}{Color of the text of the node labels
[default 'black'].}

\item{relatedness_factor}{Factor of relatedness[default 0.5].}

\item{title}{Title for the plot
[default 'Network based on genomic relationship matrix'].}

\item{palette_discrete}{A discrete palette for the color of populations or a
list with as many colors as there are populations in the dataset
 [default discrete_palette].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A network plot showing relatedness between individuals
}
\description{
This script takes a G matrix generated by \code{\link{gl.grm}} and represents
the relationship among the specimens as a network diagram. In order to use
this script, a decision is required on a threshold for relatedness to be
represented as link in the network, and on the layout used to create the
diagram.
}
\details{
As identity by descent is not an absolute state, but is relative to a
reference population for which there is generally little information, we can
estimate the kinship of a pair of individuals only relative to some other
quantity (Goudet et al., 2018). In this script, we use the average inbreeding
coefficient (1-f) of the diagonal elements as the reference value. This
reference value is then subtracted from the inbreeding coefficient of each
pair of distinct individuals. This approach is similar to the used by Goudet
et al. (2018).

Four layout options are implemented in this function:
\itemize{
\item 'fr' Fruchterman-Reingold layout  \link[igraph]{layout_with_fr}
(package igraph)
\item 'kk' Kamada-Kawai layout \link[igraph]{layout_with_kk} (package igraph)
\item 'gh' Graphopt layout \link[igraph]{layout_with_graphopt}
(package igraph)
\item 'mds' Multidimensional scaling layout \link[igraph]{layout_with_mds}
(package igraph)
}

The threshold for relatedness to be represented as a link in the network is
specified as a quantile. Those relatedness measures above the quantile are
plotted as links, those below the quantile are not. Often you are looking
 for relatedness outliers in comparison with the overall relatedness among
 individuals, so a very conservative quantile is used (e.g. 0.004), but
 ultimately, this decision is made as a matter of trial and error. One way to
  approach this trial and error is to try to achieve a sparse set of links
  between unrelated 'background' individuals so that the stronger links are
  preferentially shown.
}
\examples{
gl_test <- bandicoot.gl
# five populations in gl_test
nPop(gl_test)
# color list for population colors
pop_colors <- c('deepskyblue','green','gray','orange','deeppink')
G_out <- gl.grm(gl_test,plotheatmap=FALSE)
gl.grm.network(G_out, gl_test, palette_discrete = pop_colors, relatedness_factor = 0.25)
}
\references{
\itemize{
\item Goudet, J., Kay, T., & Weir, B. S. (2018). How to estimate kinship.
Molecular Ecology, 27(20), 4121-4135.
 }
}
\seealso{
\code{\link{gl.grm}}

Other inbreeding functions: 
\code{\link{gl.grm}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{inbreeding functions}
