% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.map.structure.r
\name{gl.map.structure}
\alias{gl.map.structure}
\title{Maps a STRUCTURE plot using a genlight object}
\usage{
gl.map.structure(
  qmat,
  x,
  provider = "Esri.NatGeoWorldMap",
  scalex = 1,
  scaley = 1,
  movepops = NULL,
  pop.labels = TRUE,
  pop.labels.cex = 12
)
}
\arguments{
\item{qmat}{Q-matrix from a structure run followed by a clumpp run object
[from \code{\link{gl.run.structure}} and \code{\link{gl.plot.structure}}]
 [required].}

\item{x}{Name of the genlight object containing the coordinates in the
\code{\@other$latlon} slot to calculate the population centers [required].}

\item{provider}{Provider    passed to leaflet. Check \link[leaflet]{providers}
for a list of possible backgrounds [default "Esri.NatGeoWorldMap"].}

\item{scalex}{Scaling factor to determine the size of the bars in x direction 
[default 1].}

\item{scaley}{Scaling factor to determine the size of the bars in y direction
[default 1].}

\item{movepops}{A two-dimensional data frame that allows to move the center of
the barplots manually in case they overlap. Often if populations are
horizontally close to each other. This needs to be a data.frame of the
dimensions [rows=number of populations, columns = 2 (lon/lat)]. For each
population you have to specify the x and y (lon and lat) units you want to
move the center of the plot, (see example for details) [default NULL].}

\item{pop.labels}{Switch for population labels below the parplots 
[default TRUE].}

\item{pop.labels.cex}{Size of population labels [default 12].}
}
\value{
An interactive map that shows the structure plots broken down by 
population.

returns the map and a list of the qmat split into sorted matrices per
 population. This can be used to create your own map.
}
\description{
This function takes the output of plotstructure (the q matrix) and maps the
q-matrix across using the population centers from the genlight object that
was used to run the structure analysis via \code{\link{gl.run.structure}})
and plots the typical structure bar plots on a spatial map, providing a
barplot for each subpopulation. Therefore it requires coordinates from a
 genlight object. This kind of plots should support the interpretation of the
  spatial structure of a population, but in principle is not different from
  \code{\link{gl.plot.structure}}
}
\details{
Creates a mapped version of structure plots. For possible background maps
check as specified via the provider:
\url{http://leaflet-extras.github.io/leaflet-providers/preview/index.html}.
You may need to adjust scalex and scaley values [default 1], as the size
depends on the scale of the map and the position of the populations.
}
\examples{
\dontrun{
#CLUMPP needs to be installed to be able to run the example
#bc <- bandicoot.gl[,1:100]
#sr <- gl.run.structure(bc, k.range = 2:5, num.k.rep = 3, exec = './structure.exe')
#ev <- gl.evanno(sr)
#ev
#qmat <- gl.plot.structure(sr, k=3, CLUMPP='d:/structure/')
#head(qmat)
#gl.map.structure(qmat, bc, scalex=1, scaley=0.5)
#move population 4 (out of 5) 0.5 degrees to the right and populations 1
#0.3 degree to the top of the map.
#mp <- data.frame(lon=c(0,0,0,0.5,0), lat=c(-0.3,0,0,0,0))
#gl.map.structure(qmat, bc, scalex=1, scaley=0.5, movepops=mp)
}
}
\references{
\itemize{
\item Pritchard, J.K., Stephens, M., Donnelly, P. (2000) Inference of
population structure using multilocus genotype data. Genetics 155, 945-959.
\item Archer, F. I., Adams, P. E. and Schneiders, B. B. (2016) strataG: An R
 package for manipulating, summarizing and analysing population genetic data.
  Mol Ecol Resour. doi:10.1111/1755-0998.12559
\item Evanno, G., Regnaut, S., and J. Goudet. 2005. Detecting the number of
clusters of individuals using the software STRUCTURE: a simulation study.
Molecular Ecology 14:2611-2620.
\item Mattias Jakobsson and Noah A. Rosenberg. 2007. CLUMPP: a cluster
matching and permutation program for dealing with label switching and
multimodality in analysis of population structure. Bioinformatics
23(14):1801-1806. Available at
\href{http://web.stanford.edu/group/rosenberglab/clumppDownload.html}{clumpp}
}
}
\seealso{
\code{\link{gl.run.structure}},  \code{clumpp},
\code{\link{gl.plot.structure}}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
