% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2sfs.R
\name{gl2sfs}
\alias{gl2sfs}
\title{Converts a genlight object into a sfs input file}
\usage{
gl2sfs(
  x,
  n.invariant.tags = 0,
  outfile_root = "gl2sfs",
  outpath = tempdir(),
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{n.invariant.tags}{Number of invariant sites[default 0].}

\item{outfile_root}{The root of the name of the output file [default "gl2sfs"].}

\item{outpath}{Path where to save the output file [default tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A list with two elements: the DAF and MAF.
}
\description{
The output of this function is suitable for analysis in fastsimcoal2 or dada.
}
\details{
It saves a derived sfs, assuming that the reference allele is the ancestral,
and a MAF sfs.

At this stage this function caters only for diploid organisms, for samples
from one population only, and for genotypes without missing data. Note that
sfs uses frequencies considered \bold{independent}, data are assumed to be
from independent (i.e. not linked) loci. This means that only one site per tag
should be considered 9i.e. secondaries should be removed). If no monomorphic
site estimates is provided (with \code{n.invariant.tags}), the sfs will only
include the number of monomorphic sites in the data (but this will be a biased
estimates as it doesn't take into account the invariant tags that have not
been included. This will affect parameter estimates in the analyses). Note
that the number of invariant tags can be estimated with
\code{gl.report.secondaries}. In a limited number of cases, ascertainment bias
can be explicitly modelled in fastsimcoal2. See fastsimcoal2 manual for
details.


It expects a dartR formatted genlight object, but it should also  work with
other genlight objects.
}
\references{
Excoffier L., Dupanloup I., Huerta-Sánchez E., Sousa V. C. and
 Foll M. (2013) Robust demographic inference from genomic and SNP data. PLoS
 genetics 9(10)
}
\seealso{
\code{\link{gl.report.heterozygosity}},
 \code{\link{gl.report.secondaries}}, \code{\link{utils.n.var.invariant}}
}
\author{
Custodian: Carlo Pacioni (Post to
 \url{https://groups.google.com/d/forum/dartr})
}
