% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.recode.ind.r
\name{gl.recode.ind}
\alias{gl.recode.ind}
\title{Recodes individual (=specimen = sample) labels in a genlight object}
\usage{
gl.recode.ind(x, ind.recode, recalc = FALSE, mono.rm = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing SNP genotypes [required].}

\item{ind.recode}{Name of the csv file containing the individual relabelling
[required].}

\item{recalc}{If TRUE, recalculate the locus metadata statistics if any 
individuals are deleted in the filtering [default FALSE].}

\item{mono.rm}{If TRUE, remove monomorphic loci [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2, 
progress log; 3, progress and results summary; 5, full report 
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight or genind object with the recoded and reduced data.
}
\description{
This script recodes individual labels and/or deletes individuals from a DaRT
genlight SNP file based on a lookup table provided as a csv file.
}
\details{
Renaming individuals may be required when there have been errors in labelling
 arising in the process from sample to DArT files. There may be occasions
 where renaming individuals is required for preparation of figures. When
 caution needs to be exercised because of the potential for breaking the
 'chain of evidence' associated with the samples, recoding individuals using
 a recode table (csv) can provide a clear record of the changes.

The script, having deleted individuals, optionally identifies resultant
 monomorphic loci or loci with all values missing and deletes them
 (using gl.filter.monomorphs.r). The script also optionally recalculates
 statistics made incorrect by the deletion of individuals from the dataset.

The script returns a genlight object with the new individual labels, the
 monomorphic loci optionally removed and the optionally recalculated locus
 metadata.
}
\examples{
  file <- system.file('extdata','testset_ind_recode.csv', package='dartR')
  gl <- gl.recode.ind(testset.gl, ind.recode=file, verbose=3)
}
\seealso{
\code{\link{gl.filter.monomorphs}} for filtering monomorphs,
 \code{\link{gl.recalc.metrics}} for recalculating locus metrics,
\code{\link{gl.recode.pop}} for recoding populations
}
\author{
Custodian: Arthur Georges -- Post to \url{https://groups.google.com/d/forum/dartr}
}
