\docType{package}
\name{dash-package}
\alias{dash}
\alias{dash-package}
\title{An Interface to the Dash Ecosystem for Authoring Reactive Web Applications}
\description{
\if{html}{\figure{logo.png}{options: width=300 align='right'}}
Dash is a productive framework for building web applications in R, Python, and Julia.

Written on top of Fiery, Plotly.js, and React.js, Dash for R is ideal for building data visualization apps with highly custom user interfaces in pure R. It's particularly suited for anyone who works with data in R.

Through a couple of simple patterns, Dash abstracts away all of the technologies and protocols that are required to build an interactive web-based application. Dash is simple enough that you can bind a user interface around your R code in an afternoon.

Dash apps are rendered in the web browser. You can deploy your apps to servers and then share them through URLs. Since Dash apps are viewed in the web browser, Dash is inherently cross-platform and mobile ready.

There is a lot behind the framework. To learn more about how it is built and what motivated Dash, watch our talk from \href{https://youtu.be/5BAthiN0htc}{Plotcon} or read our \href{https://medium.com/@plotlygraphs/introducing-dash-5ecf7191b503}{announcement letter}.

Dash is an open source package, released under the permissive MIT license. Plotly develops Dash and offers a \href{https://plotly.com/dash/pricing/}{platform for easily deploying Dash apps in an enterprise environment}. If you're interested, \href{https://plotly.typeform.com/to/rkO85m?_ga=2.223907347.9240264.1560484539-2037997284.1554944507}{please get in touch}.
}
\seealso{
Useful links:
\itemize{
  \item \url{http://dashr.plotly.com}
  \item \url{https://github.com/plotly/dashR}
  \item Report bugs at \url{https://github.com/plotly/dashR/issues}
}

}
\author{
\strong{Maintainer}: Ryan Patrick Kyle \email{ryan@plotly.com}

Authors:
\itemize{
  \item Chris Parmer \email{chris@plotly.com}
  \item Ryan Patrick Kyle \email{ryan@plotly.com}
  \item Carson Sievert
  \item Hammad Khan \email{hammadkhan@plotly.com}
}

Other contributors:
\itemize{
  \item  Plotly Technologies [copyright holder]
}

}
