% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormulaList.R
\name{FL}
\alias{FL}
\alias{makeFormulas}
\alias{update.FormulaList}
\title{Dynamically generate formulas}
\usage{
FL(..., .n = NULL, pattern = "\\\\.n")

makeFormulas(..., .n, pattern = "\\\\.n")

\method{update}{FormulaList}(object, data, ...)
}
\arguments{
\item{...}{(formulas)}

\item{.n}{names to be used in formulas. Can be any object which
can be used by \link{extract} to select columns. NULL is
interpreted to use the formulas without change.}

\item{pattern}{(character) pattern to be replaced in formulas}

\item{object}{(FormulaList)}

\item{data}{(data.frame)}
}
\description{
Function to dynamically generate formulas - (F)ormula (L)ist - to be used in
\link{mutar}.
}
\examples{
FL(.n ~ mean(.n), .n = "variable")
as(makeFormulas(.n ~ mean(.n), .n = "variable"), "FormulaList")
}
\seealso{
\link{mutar}
}
