% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\name{Aggregate}
\alias{Aggregate}
\title{Traverse a Tree and Perform Aggregation Operations}
\usage{
Aggregate(attribute, fun, ...)
}
\arguments{
\item{attribute}{the attribute that is being called on every node. The attribute can be
field, a property or a method. If the node contains #' the attribute, its value is return.
Otherwise, \code{fun(children$Aggregate(...))} is called. To use the Attribute method,
the attribute must be set on the leaf.}

\item{fun}{a function to be applied}

\item{...}{any arguments to be passed on to fun}
}
\description{
The \code{Aggregate} method lets you set e.g. a value on the leafs, and then sum them up along the tree.
}
\examples{
data(acme)
acme$Aggregate("cost", sum)
acme$Get("Aggregate", "cost", sum)
print(acme, totalCost = acme$Get("Aggregate", "cost", sum))
}
\seealso{
\code{\link{Node}}
}
\keyword{internal}

