% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_compareData.R
\name{compareData}
\alias{compareData}
\title{Compare data. Wrapper for comparison functionality.}
\usage{
compareData(DFA, DFB, keys = NULL, maxMismatches)
}
\arguments{
\item{DFA}{dataframe as returned from prepareData}

\item{DFB}{dataframe as returend from prepareData}

\item{keys}{vector of chars - names of index variables}

\item{maxMismatches}{Integer. The max number of mismatches to assess, after which dataCompareR will stop 
(without produceing an dataCompareR object). Designed to improve performance for large datasets.}
}
\value{
mismatchObject containing mismatch data for each of the variables in
        the dataframes
}
\description{
Compare data. Wrapper for comparison functionality.
}
\examples{
\dontrun{compareData(iris, iris)}

\dontrun{iris2 <- iris}
\dontrun{iris2[1,1] <- 5.2}
\dontrun{iris2[2,1] <- 5.2}
\dontrun{compareData(iris, iris2)}

\dontrun{compareData(pressure, pressure, keys = 'temperature')}
}
