% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyWhitespace.R
\name{identifyWhitespace}
\alias{identifyWhitespace}
\title{A checkFunction for identifying whitespace}
\usage{
identifyWhitespace(v, nMax = 10)
}
\arguments{
\item{v}{A character, (haven_)labelled or factor variable to check.}

\item{nMax}{The maximum number of problematic values to report. 
Default is \code{10}. Set to \code{Inf} if all problematic values are to be included 
in the outputted message, or to \code{0} for no output.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether any whitespaces were
fount), \code{$message} (a message describing which values were prefixed
or suffixed with whitespace) and \code{$problemValues} (the problematic
values). Note that only unique values are printed in the message, and that
they are sorted alphabetically.
}
\description{
A checkFunction to be called from \code{\link{check}}
that identifies prefixed and suffixed whitespace(s) in character,
(haven_)labelled or factor variables.
}
\examples{
 identifyWhitespace(c("a", " b", "c", "d ", "e  "))

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
