% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColAs.R
\name{setColAsFactorOrLogical}
\alias{setColAsFactorOrLogical}
\title{Set columns as factor}
\usage{
setColAsFactorOrLogical(dataSet, cols, n_levels = 53, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{a list of colnames of dataSet (or just one) to transform into factor}

\item{n_levels}{max number of levels for factor (integer, default to 53)}

\item{verbose}{should the function log (logical, default to TRUE)}
}
\value{
dataSet (as a \code{\link{data.table}}), with specified columns set as factor or logical.
}
\description{
Set columns as factor, or logical if they have too many different values
}
\details{
Control number of levels will help you to distinguish true categoricals from just characters 
that should be handle in another way.
}
\examples{
# Load messy_adult
data("messy_adult")

# we wil change mail and education
head(messy_adult[, .(mail, education)])

messy_adult <- setColAsFactorOrLogical(messy_adult, cols = c("mail", "education"))

sapply(messy_adult[, .(mail, education)], class)
head(messy_adult[, .(mail, education)])
# education is now a factor and mail a logical wether there was or not an mail.
}
