% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_functions.r
\name{fast_handle_na}
\alias{fast_handle_na}
\title{Handle NA values}
\usage{
fast_handle_na(
  data_set,
  set_num = 0,
  set_logical = FALSE,
  set_char = "",
  verbose = TRUE
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{set_num}{NAs replacement for numeric column, (numeric or function, default to 0)}

\item{set_logical}{NAs replacement for logical column, (logical or function, default to FALSE)}

\item{set_char}{NAs replacement for character column, (character or function, default to "")}

\item{verbose}{Should the algorithm talk (logical, default to TRUE)}
}
\value{
data_set as a \code{\link{data.table}} with NAs replaced.
}
\description{
Handle NAs values depending on the class of the column.
}
\details{
To preserve RAM this function edits data_set by \strong{reference}. To keep object unchanged,
please use \code{\link{copy}}. \cr
If you provide a function, it will be applied to the full column. So this function should handle NAs. \cr
For factor columns, it will add NA to list of values.
}
\examples{
# Build a useful data_set set for example
require(data.table)
data_set <- data.table(numCol = c(1, 2, 3, NA),
                   charCol = c("", "a", NA, "c"),
                   booleanCol = c(TRUE, NA, FALSE, NA))

# To set NAs to 0, FALSE and "" (respectively for numeric, logical, character)
fast_handle_na(copy(data_set))

# In a numeric column to set NAs as "missing"
fast_handle_na(copy(data_set), set_char = "missing")

# In a numeric column, to set NAs to the minimum value of the column#'
fast_handle_na(copy(data_set), set_num = min) # Won't work because min(c(1, NA)) = NA so put back NA
fast_handle_na(copy(data_set), set_num = function(x)min(x,na.rm = TRUE)) # Now we handle NAs

# In a numeric column, to set NAs to the share of NAs values
rateNA <- function(x) {
  sum(is.na(x)) / length(x)
}
fast_handle_na(copy(data_set), set_num = rateNA)

}
