% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates_manipulations.R
\name{date_format_unifier}
\alias{date_format_unifier}
\title{Unify dates format}
\usage{
date_format_unifier(data_set, format = "Date")
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{format}{Desired target format: Date, POSIXct or POSIXlt, (character, default to Date)}
}
\value{
The same data_set set but with dates column with the desired format.
}
\description{
Unify every column in a date format to the same date format.
}
\details{
This function only handle Date, POSIXct and POSIXlt dates.  \cr
POSIXct format is a bit slower than Date but can keep hours-min.
}
\examples{
# build a data.table
require(data.table)
data_set <- data.table( column1 = as.Date("2016-01-01"), column2 = as.POSIXct("2017-01-01") )

# Use the function
data_set = date_format_unifier(data_set, format = "Date")

# Control result
sapply(data_set, class)
# return Date for both columns
}
