% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISunitData}
\alias{getNWISunitData}
\alias{readNWISuv}
\title{Raw Data Import for Instantaneous USGS NWIS Data}
\usage{
getNWISunitData(siteNumbers, parameterCd, startDate = "", endDate = "",
  tz = "")

readNWISuv(siteNumbers, parameterCd, startDate = "", endDate = "",
  tz = "")
}
\arguments{
\item{siteNumbers}{string USGS site number (or multiple sites).  This is usually an 8 digit number}

\item{parameterCd}{string USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{tz}{string to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
data dataframe with agency, site, dateTime, time zone, value, and code columns
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{http://waterservices.usgs.gov/}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
siteNumber <- '05114000'
parameterCd <- '00060'
startDate <- "2014-10-10"
endDate <- "2014-10-10"
# These examples require an internet connection to run
rawData <- readNWISuv(siteNumber,parameterCd,startDate,endDate)

timeZoneChange <- readNWISuv(c('04024430','04024000'),parameterCd,
         "2013-11-03","2013-11-03")
firstSite <- timeZoneChange[timeZoneChange$site_no == '04024430',]
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

