% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/importWaterML2.r
\name{importWaterML2}
\alias{importWaterML2}
\title{Function to return data from the WaterML2 data}
\usage{
importWaterML2(obs_url, asDateTime = FALSE, tz = "")
}
\arguments{
\item{obs_url}{character containing the url for the retrieval}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, Date}

\item{tz}{character to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
mergedDF a data frame time, value, description, qualifier, and identifier
}
\description{
This function accepts a url parameter for a WaterML2 getObservation. This function is still under development,
but the general functionality is correct.
}
\examples{
baseURL <- "http://waterservices.usgs.gov/nwis/dv/?format=waterml,2.0"
URL <- paste(baseURL, "sites=01646500",
     "startDT=2014-09-01",
     "endDT=2014-09-08",
     "statCd=00003",
     "parameterCd=00060",sep="&")
URL2 <- paste("http://cida.usgs.gov/noreast-sos/simple?request=GetObservation",
     "featureID=MD-BC-BC-05",
     "offering=RAW",
     "observedProperty=WATER",sep="&")
\dontrun{
dataReturned1 <- importWaterML2(URL)
dataReturn2 <- importWaterML2(URL2, TRUE)
URLmulti <-  paste(baseURL,
  "sites=04024430,04024000",
  "startDT=2014-09-01",
  "endDT=2014-09-08",
  "statCd=00003",
  "parameterCd=00060",sep="&")
dataReturnMulti <- importWaterML2(URLmulti)
}
filePath <- system.file("extdata", package="dataRetrieval")
fileName <- "WaterML2Example.xml"
fullPath <- file.path(filePath, fileName)
UserData <- importWaterML2(fullPath)
}

