% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata.R
\name{read_waterdata}
\alias{read_waterdata}
\title{Generalized USGS Water Data API retrieval function}
\usage{
read_waterdata(service, CQL, ..., convertType = TRUE)
}
\arguments{
\item{service}{character, can be any existing collection such
as "daily", "monitoring-locations", "time-series-metadata"}

\item{CQL}{A string in a Common Query Language format.}

\item{\dots}{Additional arguments to send to the request.}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates and qualifier to string vector.}
}
\description{
Function that allows complex CQL queries.
See \url{https://api.waterdata.usgs.gov/docs/ogcapi/complex-queries/}
for more information.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
cql <- '{
"op": "and",
"args": [
  {
    "op": "in",
    "args": [
      { "property": "parameter_code" },
      [ "00060", "00065" ]
    ]
  },
 {
    "op": "in",
    "args": [
      { "property": "monitoring_location_id" },
      [ "USGS-07367300", "USGS-03277200" ]
    ]
  }
]
}'

dv_data <- read_waterdata(service = "daily",
                          CQL = cql,
                          time = c("2023-01-01", "2024-01-01"))

}
\dontshow{\}) # examplesIf}
}
