% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDDM_W.R
\name{HDDM_W}
\alias{HDDM_W}
\title{KSWIN (Kolmogorov-Smirnov WINdowing) for Change Detection}
\description{
Implements the Kolmogorov-Smirnov test for detecting distribution changes within
a window of streaming data. KSWIN is a non-parametric method for change detection that compares
two samples to determine if they come from the same distribution.
}
\details{
KSWIN is effective for detecting changes in the underlying distribution of data streams.
It is particularly useful in scenarios where data properties may evolve over time, allowing for
early detection of changes that might affect subsequent data processing.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)

# Initialize the HDDM_W object
hddm_w_instance <- HDDM_W$new()

# Iterate through the data stream
for(i in seq_along(data_stream)) {
  hddm_w_instance$add_element(data_stream[i])
  if(hddm_w_instance$warning_detected) {
    message(paste("Warning detected at index:", i))
  }
  if(hddm_w_instance$change_detected) {
    message(paste("Concept drift detected at index:", i))
  }
}
}
\references{
Frías-Blanco I, del Campo-Ávila J, Ramos-Jimenez G, et al. Online and non-parametric drift detection methods based
on Hoeffding’s bounds. IEEE Transactions on Knowledge and Data Engineering, 2014, 27(3): 810-823.

Albert Bifet, Geoff Holmes, Richard Kirkby, Bernhard Pfahringer. MOA: Massive Online Analysis;
Journal of Machine Learning Research 11: 1601-1604, 2010.
Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/hddm_w.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{drift_confidence}}{Confidence level for detecting a drift (default: 0.001).}

\item{\code{warning_confidence}}{Confidence level for warning detection (default: 0.005).}

\item{\code{lambda_option}}{Decay rate for the EWMA statistic, smaller values give less weight to recent data (default: 0.050).}

\item{\code{two_side_option}}{Boolean flag for one-sided or two-sided error monitoring (default: TRUE).}

\item{\code{total}}{Container for the EWMA estimator and its bounded conditional sum.}

\item{\code{sample1_decr_monitor}}{First sample monitor for detecting decrements.}

\item{\code{sample1_incr_monitor}}{First sample monitor for detecting increments.}

\item{\code{sample2_decr_monitor}}{Second sample monitor for detecting decrements.}

\item{\code{sample2_incr_monitor}}{Second sample monitor for detecting increments.}

\item{\code{incr_cutpoint}}{Cutpoint for deciding increments.}

\item{\code{decr_cutpoint}}{Cutpoint for deciding decrements.}

\item{\code{width}}{Current width of the window.}

\item{\code{delay}}{Delay count since last reset.}

\item{\code{change_detected}}{Boolean indicating if a change was detected.}

\item{\code{warning_detected}}{Boolean indicating if currently in a warning zone.}

\item{\code{estimation}}{The current estimation of the stream's mean.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HDDM_W-new}{\code{HDDM_W$new()}}
\item \href{#method-HDDM_W-add_element}{\code{HDDM_W$add_element()}}
\item \href{#method-HDDM_W-SampleInfo}{\code{HDDM_W$SampleInfo()}}
\item \href{#method-HDDM_W-reset}{\code{HDDM_W$reset()}}
\item \href{#method-HDDM_W-detect_mean_increment}{\code{HDDM_W$detect_mean_increment()}}
\item \href{#method-HDDM_W-monitor_mean_incr}{\code{HDDM_W$monitor_mean_incr()}}
\item \href{#method-HDDM_W-monitor_mean_decr}{\code{HDDM_W$monitor_mean_decr()}}
\item \href{#method-HDDM_W-update_incr_statistics}{\code{HDDM_W$update_incr_statistics()}}
\item \href{#method-HDDM_W-update_decr_statistics}{\code{HDDM_W$update_decr_statistics()}}
\item \href{#method-HDDM_W-clone}{\code{HDDM_W$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-new"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-new}{}}}
\subsection{Method \code{new()}}{
Initializes the HDDM_W detector with specific parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$new(
  drift_confidence = 0.001,
  warning_confidence = 0.005,
  lambda_option = 0.05,
  two_side_option = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drift_confidence}}{Confidence level for drift detection.}

\item{\code{warning_confidence}}{Confidence level for issuing warnings.}

\item{\code{lambda_option}}{Decay rate for the EWMA statistic.}

\item{\code{two_side_option}}{Whether to monitor both increases and decreases.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds a new element to the data stream and updates the detection status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$add_element(prediction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prediction}}{The new data value to add.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-SampleInfo"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-SampleInfo}{}}}
\subsection{Method \code{SampleInfo()}}{
Provides current information about the monitoring samples, typically used for debugging or monitoring.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$SampleInfo()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-reset"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state to initial conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-detect_mean_increment"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-detect_mean_increment}{}}}
\subsection{Method \code{detect_mean_increment()}}{
Detects an increment in the mean between two samples based on the provided confidence level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$detect_mean_increment(sample1, sample2, confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sample1}}{First sample information, containing EWMA estimator and bounded conditional sum.}

\item{\code{sample2}}{Second sample information, containing EWMA estimator and bounded conditional sum.}

\item{\code{confidence}}{The confidence level used for calculating the bound.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean indicating if an increment in mean was detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-monitor_mean_incr"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-monitor_mean_incr}{}}}
\subsection{Method \code{monitor_mean_incr()}}{
Monitors the data stream for an increase in the mean based on the set confidence level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$monitor_mean_incr(confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{confidence}}{The confidence level used to detect changes in the mean.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean indicating if an increase in the mean was detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-monitor_mean_decr"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-monitor_mean_decr}{}}}
\subsection{Method \code{monitor_mean_decr()}}{
Monitors the data stream for a decrease in the mean based on the set confidence level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$monitor_mean_decr(confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{confidence}}{The confidence level used to detect changes in the mean.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean indicating if a decrease in the mean was detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-update_incr_statistics"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-update_incr_statistics}{}}}
\subsection{Method \code{update_incr_statistics()}}{
Updates increment statistics for drift monitoring based on new values and confidence.
This method adjusts the cutpoint for increments and updates the monitoring samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$update_incr_statistics(value, confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The new value to update statistics.}

\item{\code{confidence}}{The confidence level for the update.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-update_decr_statistics"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-update_decr_statistics}{}}}
\subsection{Method \code{update_decr_statistics()}}{
Updates decrement statistics for drift monitoring based on new values and confidence.
This method adjusts the cutpoint for decrements and updates the monitoring samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$update_decr_statistics(value, confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The new value to update statistics.}

\item{\code{confidence}}{The confidence level for the update.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_W-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_W-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_W$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
