% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{psptime}
\alias{psptime}
\title{Remeasurements of a permanent sample plot in a radiata pine plantation (Chile).}
\format{
The data frame contains the following columns:
\describe{
\item{plot.no}{plot id}	 
\item{tree.no}{tree id}
\item{dbh}{Diameter at breast-height, in cm.}
\item{year}{Measurement year.} 											
\item{x}{Cartesian position at the X-axis, in m.}
\item{y}{Cartesian position at the Y-axis, in m.}
\item{dead}{if the tree is dead,this column is equal to 1, and 0 otherwise.}
 }
}
\source{
Data were obtained from the files available at \url{https://zenodo.org/record/7341482}.
}
\usage{
data(psptime)
}
\description{
Annual remeasurements of trees within a 1600 m\eqn{^{2}}{^2} permanent sample plot established in a radiata pine
 plantation in Chile. Besides, the trees location are available.  The plot is square (40 m × 40 m), and
 if a tree is found dead, the column dead=1.
}
\examples{
data(psptime)    
head(psptime) 
tapply(psptime$dbh,psptime$year,mean)
library(lattice)
histogram(~dbh|as.factor(year), data=psptime)
}
\references{
Pommerening A, Trincado G, Salas-Eljatib C, Burkhart H. 2023. Understanding and modelling the dynamics of data point
 clouds of relative growth rate and plant size. Forest Ecology and 
 management Volume 529, 1206525 \doi{10.1016/j.foreco.2022.120652}
}
\keyword{datasets}
