% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{uploadDataObject}
\alias{uploadDataObject}
\alias{uploadDataObject,D1Client-method}
\title{Upload a DataObject to a DataONE member node.}
\usage{
uploadDataObject(x, ...)

\S4method{uploadDataObject}{D1Client}(x, do, replicate = as.logical(FALSE),
  numberReplicas = NA, preferredNodes = NA, public = as.logical(FALSE),
  accessRules = NA, quiet = TRUE, ...)
}
\arguments{
\item{x}{A D1Client instance.}

\item{...}{(Not yet used.)}

\item{do}{The DataObject instance to be uploaded to DataONE.}

\item{replicate}{A value of type \code{"logical"}, if TRUE then DataONE will replicate this object to other member nodes}

\item{numberReplicas}{A value of type \code{"numeric"}, for number of supported replicas.}

\item{preferredNodes}{A list of \code{"character"}, each of which is the node identifier for a node to which a replica should be sent.}

\item{public}{A \code{"logical"} value - if TRUE then the uploaded object will be publicly readable.}

\item{accessRules}{Access rules of \code{'data.frame'} that will be added to the access policy}

\item{quiet}{A \code{'logical'}. If TRUE (the default) then informational messages will not be printed.}
}
\value{
id The id of the DataObject that was uploaded
}
\description{
Upload a DataObject to a DataONE member node.
}
\examples{
\dontrun{
library(dataone)
library(datapack)
testdf <- data.frame(x=1:10,y=11:20)
csvfile <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".csv")
write.csv(testdf, csvfile, row.names=FALSE)
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
do <- new("DataObject", format="text/csv", mnNodeId=getMNodeId(d1c), filename=csvfile)
# Upload a single DataObject to DataONE (requires authentication)
newId <- uploadDataObject(d1c, do, replicate=FALSE, preferredNodes=NA ,  public=TRUE)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
