/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.ore;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.util.EncodingUtilities;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.OREParserFactory;
import org.dspace.foresite.OREResource;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.TripleJena;

public class ResourceMapFactory {
    private static final String D1_URI_PREFIX = Settings.getConfiguration().getString("D1Client.CN_URL", "howdy") + "/v1/resolve/";
    private static final String RESOURCE_MAP_SERIALIZATION_FORMAT = "RDF/XML";
    private static Predicate DC_TERMS_IDENTIFIER = null;
    private static Predicate CITO_IS_DOCUMENTED_BY = null;
    private static Predicate CITO_DOCUMENTS = null;
    private static ResourceMapFactory instance = null;

    private void init() throws URISyntaxException {
        DC_TERMS_IDENTIFIER = new Predicate();
        DC_TERMS_IDENTIFIER.setNamespace(Vocab.dcterms_Agent.ns().toString());
        DC_TERMS_IDENTIFIER.setPrefix(Vocab.dcterms_Agent.schema());
        DC_TERMS_IDENTIFIER.setName("identifier");
        DC_TERMS_IDENTIFIER.setURI(new URI(DC_TERMS_IDENTIFIER.getNamespace() + DC_TERMS_IDENTIFIER.getName()));
        CITO_IS_DOCUMENTED_BY = new Predicate();
        CITO_IS_DOCUMENTED_BY.setNamespace("http://purl.org/spar/cito/");
        CITO_IS_DOCUMENTED_BY.setPrefix("cito");
        CITO_IS_DOCUMENTED_BY.setName("isDocumentedBy");
        CITO_IS_DOCUMENTED_BY.setURI(new URI(CITO_IS_DOCUMENTED_BY.getNamespace() + CITO_IS_DOCUMENTED_BY.getName()));
        CITO_DOCUMENTS = new Predicate();
        CITO_DOCUMENTS.setNamespace(CITO_IS_DOCUMENTED_BY.getNamespace());
        CITO_DOCUMENTS.setPrefix(CITO_IS_DOCUMENTED_BY.getPrefix());
        CITO_DOCUMENTS.setName("documents");
        CITO_DOCUMENTS.setURI(new URI(CITO_DOCUMENTS.getNamespace() + CITO_DOCUMENTS.getName()));
    }

    private ResourceMapFactory() {
        try {
            this.init();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static ResourceMapFactory getInstance() {
        if (instance == null) {
            instance = new ResourceMapFactory();
        }
        return instance;
    }

    public ResourceMap createResourceMap(Identifier resourceMapId, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        Aggregation aggregation = OREFactory.createAggregation((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)resourceMapId.getValue()) + "#aggregation"));
        ResourceMap resourceMap = aggregation.createResourceMap(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)resourceMapId.getValue())));
        Agent creator = OREFactory.createAgent();
        creator.addName("Java libclient");
        resourceMap.addCreator(creator);
        TripleJena resourceMapIdentifier = new TripleJena();
        resourceMapIdentifier.initialise((OREResource)resourceMap);
        resourceMapIdentifier.relate(DC_TERMS_IDENTIFIER, (Object)resourceMapId.getValue());
        resourceMap.addTriple((Triple)resourceMapIdentifier);
        aggregation.addTitle("DataONE Aggregation");
        for (Identifier metadataId : idMap.keySet()) {
            AggregatedResource metadataResource = aggregation.createAggregatedResource(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)metadataId.getValue())));
            TripleJena metadataIdentifier = new TripleJena();
            metadataIdentifier.initialise((OREResource)metadataResource);
            metadataIdentifier.relate(DC_TERMS_IDENTIFIER, (Object)metadataId.getValue());
            resourceMap.addTriple((Triple)metadataIdentifier);
            aggregation.addAggregatedResource(metadataResource);
            List<Identifier> dataIds = idMap.get(metadataId);
            for (Identifier dataId : dataIds) {
                AggregatedResource dataResource = aggregation.createAggregatedResource(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)dataId.getValue())));
                TripleJena identifier = new TripleJena();
                identifier.initialise((OREResource)dataResource);
                identifier.relate(DC_TERMS_IDENTIFIER, (Object)dataId.getValue());
                resourceMap.addTriple((Triple)identifier);
                TripleJena isDocumentedBy = new TripleJena();
                isDocumentedBy.initialise((OREResource)dataResource);
                isDocumentedBy.relate(CITO_IS_DOCUMENTED_BY, (OREResource)metadataResource);
                resourceMap.addTriple((Triple)isDocumentedBy);
                TripleJena documents = new TripleJena();
                documents.initialise((OREResource)metadataResource);
                documents.relate(CITO_DOCUMENTS, (OREResource)dataResource);
                resourceMap.addTriple((Triple)documents);
                aggregation.addAggregatedResource(dataResource);
            }
        }
        return resourceMap;
    }

    public Map<Identifier, Map<Identifier, List<Identifier>>> parseResourceMap(String resourceMapContents) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        ByteArrayInputStream is = new ByteArrayInputStream(resourceMapContents.getBytes("UTF-8"));
        return this.parseResourceMap(is);
    }

    public Map<Identifier, Map<Identifier, List<Identifier>>> parseResourceMap(InputStream is) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        HashMap idMap = new HashMap();
        OREParser parser = OREParserFactory.getInstance((String)RESOURCE_MAP_SERIALIZATION_FORMAT);
        ResourceMap resourceMap = parser.parse(is);
        Identifier packageId = new Identifier();
        TripleSelector packageIdSelector = new TripleSelector(resourceMap.getURI(), DC_TERMS_IDENTIFIER.getURI(), null);
        List packageIdTriples = resourceMap.listTriples(packageIdSelector);
        if (!packageIdTriples.isEmpty()) {
            String packageIdValue = ((Triple)packageIdTriples.get(0)).getObjectLiteral();
            packageId.setValue(EncodingUtilities.decodeString((String)packageIdValue));
        }
        Aggregation aggregation = resourceMap.getAggregation();
        List resources = aggregation.getAggregatedResources();
        for (AggregatedResource entry : resources) {
            Identifier metadataId = new Identifier();
            ArrayList<Identifier> dataIds = new ArrayList<Identifier>();
            TripleSelector documentsSelector = new TripleSelector(null, CITO_DOCUMENTS.getURI(), null);
            List documentsTriples = entry.listTriples(documentsSelector);
            if (documentsTriples.isEmpty()) continue;
            TripleSelector identifierSelector = new TripleSelector(null, DC_TERMS_IDENTIFIER.getURI(), null);
            List identifierTriples = entry.listTriples(identifierSelector);
            if (!identifierTriples.isEmpty()) {
                String metadataIdValue = ((Triple)identifierTriples.get(0)).getObjectLiteral();
                metadataId.setValue(EncodingUtilities.decodeString((String)metadataIdValue));
            }
            for (Triple triple : documentsTriples) {
                String dataIdValue = null;
                URI dataResourceURI = triple.getObjectURI();
                TripleSelector dataIdentifierSelector = new TripleSelector(dataResourceURI, DC_TERMS_IDENTIFIER.getURI(), null);
                List dataIdentifierTriples = resourceMap.listAllTriples(dataIdentifierSelector);
                if (!dataIdentifierTriples.isEmpty()) {
                    dataIdValue = ((Triple)dataIdentifierTriples.get(0)).getObjectLiteral();
                }
                Identifier dataId = new Identifier();
                dataId.setValue(EncodingUtilities.decodeString((String)dataIdValue));
                dataIds.add(dataId);
            }
            idMap.put(metadataId, dataIds);
        }
        HashMap<Identifier, Map<Identifier, List<Identifier>>> packageMap = new HashMap<Identifier, Map<Identifier, List<Identifier>>>();
        packageMap.put(packageId, idMap);
        return packageMap;
    }

    public String serializeResourceMap(ResourceMap resourceMap) throws ORESerialiserException {
        ORESerialiser serializer = ORESerialiserFactory.getInstance((String)RESOURCE_MAP_SERIALIZATION_FORMAT);
        ResourceMapDocument doc = serializer.serialise(resourceMap);
        String serialisation = doc.toString();
        return serialisation;
    }
}

