% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataObject.R, R/DataPackage.R
\docType{methods}
\name{getData}
\alias{getData}
\alias{getData,DataObject-method}
\alias{getData,DataPackage-method}
\title{Get the data content of a specified data object}
\usage{
getData(x, ...)

\S4method{getData}{DataObject}(x)

\S4method{getData}{DataPackage}(x, id)
}
\arguments{
\item{x}{DataObject or DataPackage: the data structure from where to get the data}

\item{...}{Additional arguments}

\item{id}{Missing or character: if \code{'x'} is DataPackage, the identifier of the
package member to get data from}
}
\value{
raw representation of the data
}
\description{
Get the data content of a specified data object
}
\examples{
data <- charToRaw("1,2,3\\n4,5,6\\n")
do <- new("DataObject", "id1", dataobj=data, "text/csv", 
  "uid=jones,DC=example,DC=com", "urn:node:KNB")
bytes <- getData(do)
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do1 <- new("DataObject", id="id1", data, format="text/csv", user="smith", mnNodeId="urn:node:KNB")
dp <- addData(dp, do1)
bytes <- getData(dp, "id1")
}
\seealso{
\code{\link{DataObject-class}}
}

