% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{removeMember}
\alias{removeMember}
\alias{removeMember,DataPackage-method}
\title{Remove the Specified Member from the Package}
\usage{
removeMember(x, ...)

\S4method{removeMember}{DataPackage}(x, identifier)
}
\arguments{
\item{x}{a Datapackage object}

\item{...}{(Not yet used)}

\item{identifier}{an identifier for a DataObject}
}
\description{
Given the identifier of a member of the data package, delete the DataObject
representation of the member.
}
\examples{
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do <- new("DataObject", id="myNewId", dataobj=data, format="text/csv", user="jsmith")
dp <- addData(dp, do)
removeMember(dp, "myNewId")
}
\seealso{
\code{\link{DataPackage-class}}
}
