% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\docType{methods}
\name{serializeSystemMetadata}
\alias{serializeSystemMetadata}
\alias{serializeSystemMetadata,SystemMetadata-method}
\title{Serialize a SystemMetadata object to an XML representation}
\usage{
serializeSystemMetadata(x, ...)

\S4method{serializeSystemMetadata}{SystemMetadata}(x, version = "v1",
  ...)
}
\arguments{
\item{x}{The SystemMetadata instance to be serialized.}

\item{...}{(Not currently used)}

\item{version}{A character string representing the DataONE API version that this system will be used with (e.g. "v1", "v2").}
}
\value{
A character value of the filename that the XML representation of the SystemMetadata object was written to.

the character string representing a SystemMetadata object
}
\description{
The SystemMetadata object is converted to XML and 
written to a file.
}
\details{
If the \code{'version'} parameter is specified as *v2* then the SystemMetadata
object is serialized according to the DataONE version 2.0 system metadata format.
}
\examples{
library(XML)
doc <- xmlParseDoc(system.file("testfiles/sysmeta.xml", package="datapack"), asText=FALSE)
sysmeta <- new("SystemMetadata")
sysmeta <- parseSystemMetadata(sysmeta, xmlRoot(doc))
sysmetaXML <- serializeSystemMetadata(sysmeta, version="v2")
}
\seealso{
\code{\link{SystemMetadata-class}}
}
