% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_distributions.R
\name{acc_distributions}
\alias{acc_distributions}
\title{Function to plot histograms added by empirical cumulative distributions
for subgroups}
\usage{
acc_distributions(
  resp_vars = NULL,
  label_col,
  group_vars = NULL,
  study_data,
  meta_data
)
}
\arguments{
\item{resp_vars}{\link{variable list} the names of the measurement variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{group_vars}{\link{variable list} the name of the observer, device or
reader variable}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}
}
\value{
A \link{list} with:
\itemize{
\item \code{SummaryPlots}: \link{list} of \link{ggplot}s for each response variable in
\code{resp_vars}.
}
}
\description{
Function to identify inadmissible measurements according to hard limits
(multiple variables)
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Select all variables of type float or integer in the study data
\item Remove missing codes from the study data (if defined in the metadata)
\item Remove measurements deviating from limits defined in the metadata
\item Plot histograms
\itemize{
\item If group_vars is specified by the user, distributions within
group-wise ecdf are presented.
}
}
}

\seealso{
\href{https://dataquality.ship-med.uni-greifswald.de/VIN_acc_impl_distributions.html}{Online Documentation}
}
