% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_datatype_matrix.R
\name{int_datatype_matrix}
\alias{int_datatype_matrix}
\title{Check declared data types of metadata in study data}
\usage{
int_datatype_matrix(
  resp_vars = NULL,
  study_data,
  meta_data,
  split_segments = FALSE,
  label_col,
  max_vars_per_plot = 20,
  threshold_value = 0
)
}
\arguments{
\item{resp_vars}{\link{variable} the names of the measurement variables, if
missing or \code{NULL}, all variables will be checked}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{split_segments}{\link{logical} return one matrix per study segment}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{max_vars_per_plot}{\link{integer} from=0. The maximum number of variables
per single plot.}

\item{threshold_value}{\link{numeric} from=0 to=100. percentage failing
conversions allowed to still classify a
study variable convertible.
\code{inheritParams} \code{acc_distributions}}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame about the applicability of each indicator
function (each function in a column).
its \link{integer} values can be one of the following four
categories:
0. Non-matching datatype,
1. Matching datatype,
\item \code{SummaryPlot}: \link{ggplot2} heatmap plot, graphical representation of
\code{SummaryTable}
\item \code{DataTypePlotList}: \link{list} of plots per (maybe artificial) segment
\item \code{ReportSummaryTable}: data frame underlying \code{SummaryPlot}
}
}
\description{
Checks data types of the study data and for the data type
declared in the metadata

\link{Indicator}
}
\details{
This is a preparatory support function that compares study data with
associated metadata. A prerequisite of this function is that the no. of
columns in the study data complies with the no. of rows in the metadata.

For each study variable, the function searches for its data type declared in
static metadata and returns a heatmap like matrix indicating data type
mismatches in the study data.

List function.
}
\examples{
\dontrun{
load(system.file("extdata/meta_data.RData", package = "dataquieR"), envir =
  environment())
load(system.file("extdata/study_data.RData", package = "dataquieR"), envir =
  environment())
study_data$v00000 <- as.character(study_data$v00000)
study_data$v00002 <- as.character(study_data$v00002)
study_data$v00002[3] <- ""
appmatrix <- int_datatype_matrix(study_data = study_data,
                                 meta_data = meta_data,
                                 label_col = LABEL)
study_data$v00002[5] <- "X"
appmatrix <- int_datatype_matrix(study_data = study_data,
                                 meta_data = meta_data,
                                 label_col = LABEL)
appmatrix$ReportSummaryTable
}
}
