% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_ensure_character.R
\name{util_ensure_character}
\alias{util_ensure_character}
\title{convert a value to character}
\usage{
util_ensure_character(x, error = FALSE, error_msg, ...)
}
\arguments{
\item{x}{the value}

\item{error}{\link{logical} if \code{TRUE}, an error is thrown, a warning otherwise
in case of a conversion error}

\item{error_msg}{error message to be  displayed, if conversion was not
possible}

\item{...}{additional arguments passed to \link{util_error} or \link{util_warning}
respectively in case of an error, and if an \code{error_msg} has
been passed}
}
\value{
as.character(x)
}
\description{
convert a value to character
}
\seealso{
Other robustness_functions: 
\code{\link{util_as_valid_missing_codes}()},
\code{\link{util_check_one_unique_value}()},
\code{\link{util_correct_variable_use}()},
\code{\link{util_empty}()},
\code{\link{util_ensure_in}()},
\code{\link{util_ensure_suggested}()},
\code{\link{util_expect_scalar}()},
\code{\link{util_fix_rstudio_bugs}()},
\code{\link{util_is_integer}()},
\code{\link{util_is_numeric_in}()},
\code{\link{util_is_valid_missing_codes}()},
\code{\link{util_match_arg}()},
\code{\link{util_observations_in_subgroups}()},
\code{\link{util_only_NAs}()},
\code{\link{util_stop_if_not}()},
\code{\link{util_warn_unordered}()}
}
\concept{robustness}
\concept{robustness_functions}
\keyword{internal}
