% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdvancedTuning.R
\name{summary.listOfDataRobotTuningParameters}
\alias{summary.listOfDataRobotTuningParameters}
\title{Summarize the list of tuning parameters available for a model.}
\usage{
\method{summary}{listOfDataRobotTuningParameters}(object, ...)
}
\arguments{
\item{object}{list. The list of tuning parameters to summarize.}

\item{...}{list. Extra parameters that are ignored. Used to allow S3 inheritance to work.}
}
\value{
A data.frame detailing the following about each tuning parameter:
\itemize{
  \item name character. The name of the tuning parameter.
  \item current character. The current searched values of that parameter.
  \item default character. The default value of that parameter.
  \item constraint character. A short description of the possible values that parameter can take.
}
}
\description{
Summarize the list of tuning parameters available for a model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  summary(GetTuningParameters(model))
}
}
