% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComplianceDocumentation.R
\name{CreateComplianceDocumentation}
\alias{CreateComplianceDocumentation}
\title{Create compliance documentation from a model.}
\usage{
CreateComplianceDocumentation(model, templateId = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{templateId}{character. Optional. The ID of the template to use in generating custom
model documentation.}
}
\value{
An integer value that can be used as the jobId parameter in a subsequent call
  to \code{WaitForJobToComplete}.
}
\description{
Note that if you're looking to download compliance documentation to a DOCX file, you can
call \code{DownloadComplianceDocumentation} directly without using this function.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  jobId <- CreateComplianceDocumentation(model) # optional step
  WaitForJobToComplete(projectId, jobId)        # optional step
  DownloadComplianceDocumentation(model)
}
}
