% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateBacktestSpecification}
\alias{CreateBacktestSpecification}
\title{Create a list describing backtest parameters}
\usage{
CreateBacktestSpecification(index, gapDuration, validationStartDate,
  validationDuration)
}
\arguments{
\item{index}{Integer the index of the backtest}

\item{gapDuration}{Character string the desired duration of the gap 
between training and validation data for the backtest}

\item{validationStartDate}{Character string  the desired start date 
of the validation data for this backtest (RFC 3339 format)}

\item{validationDuration}{Character string the desired end date 
of the validation data for this backtest as return by ConstructDurationString (ISO8601 format)}
}
\value{
list with backtest parameters
}
\description{
Uniquely defines a Backtest used in a DatetimePartitioning
}
\details{
Includes only the attributes of a backtest directly controllable by users.  The other attributes
are assigned by the DataRobot application based on the project dataset and the user-controlled
settings.
All durations should be specified with a duration string such as those returned
by the ConstructDurationString helper function.
}
