% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictJobs.R
\name{GetPredictJobs}
\alias{GetPredictJobs}
\title{Function to list all prediction jobs in a project}
\usage{
GetPredictJobs(project, status = NULL)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric identifier for the
project, or (2) a list containing the element projectId with this identifier.}

\item{status}{The status of the desired jobs: one of JobStatus$Queue, JobStatus$InProgress, or
JobStatus$Error. If NULL (default), queued and inprogress jobs are returned.}
}
\value{
Dataframe with one row for each prediction job in the queue,
with the following columns:
\describe{
  \item{status}{Prediction job status; one of JobStatus$Queue, JobStatus$InProgress, or
JobStatus$Error}
  \item{predictJobId}{Character string specifying the job id}
  \item{modelId}{Character string specifying the model from which
  predictions have been requested.}
  \item{projectId}{Character string specifying the project that contains the model.}
}
}
\description{
Function to list all prediction jobs in a project
}
