% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{measures}
\alias{measures}
\alias{measures<-}
\title{Measures of a dataset}
\usage{
measures(x)

measures(x) <- value
}
\arguments{
\item{x}{A data.frame or inherited tibble, data.frame, or a structured list.}

\item{value}{The name or column number of the within the dataset.}
}
\value{
A data frame of the names, class, isDefinedBy, and codeList properties of the measurement columns of a
dataset following the datacube model.
}
\description{
Measures of a dataset
}
\details{
See the W3C and SDMX definition of a \href{https://www.w3.org/TR/vocab-data-cube/#dsd-dimensions}{measure}.
}
\examples{
df <- data.frame ( sex = c("M", "F"), value = c(1,2), unit = c("NR", "NR"))
dimensions(df, sdmx_attributes = "sex") <- "sex"
measures(df) <- "value"
attributes_measures(df) <- "unit"
measures(df)
df <- data.frame ( sex = c("M", "F"), value = c(1,2))
measures(df) <- "value"
measures(df)
}
