% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{size}
\alias{size}
\alias{size<-}
\title{Get/Estimate/Add the Size metadata to an object}
\usage{
size(x)

size(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset}}.}

\item{overwrite}{If a warning should be given when trying to overwrite an
existing \code{Size} property, defaults to \code{TRUE}.\cr
The estimated object size in memory is added in SI
kB and IEC KiB (legacy Kb) units,
rounded to two decimals.}

\item{value}{A string (size of the dataset in a certain serialisation),
or \code{"estimate"} produces and estimate with \code{[utils]{object.size}}.}
}
\value{
Returns the \code{size} metadata field of the \code{DataBibentry} of
the dataset.
}
\description{
Add the optional DataCite \code{Size} property as an attribute to an R object.
}
\details{
\code{Size} is an optional property in DataCite 4.4. See:
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#13-size}{datacite:Size}.
The object size is estimated with \code{\link[utils:object.size]{utils::object.size}} and it may differ
from the actual serialisation to another file format.
}
\examples{
size(iris_dataset) <- "estimate"
size(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{datasource_get}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
