% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dataset_file.R
\name{add_dataset_file}
\alias{add_dataset_file}
\alias{update_dataset_file}
\title{Add or update a file in a dataset}
\usage{
add_dataset_file(file, dataset, description = NULL,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"), ...)

update_dataset_file(file, dataset = NULL, id, description = NULL,
  force = TRUE, key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"), ...)
}
\arguments{
\item{file}{A character string}

\item{dataset}{An integer specifying a dataset identification number or an object of class \dQuote{dataverse_dataset}. The identification number is the dataset's persistent identification number (not the integer specifying a specific version of the dataset, such as returned by \code{\link{dataset_versions}}).}

\item{description}{Optionally, a character string providing a description of the file.}

\item{key}{A character string specifying a Dataverse server API key. If one is not specified, functions calling authenticated API endpoints will fail. Keys can be specified atomically or globally using \code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are multiple Dataverse installations, but the defaults is to use the Harvard Dataverse. This can be modified atomically or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{...}{Additional arguments passed to an HTTP request function, such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or \code{\link[httr]{DELETE}}.}

\item{id}{An integer specifying a file identifier; or, if \code{doi} is specified, a character string specifying a file name within the DOI-identified dataset; or an object of class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.}

\item{force}{A logical indicating whether to force the update even if the file types differ. Default is \code{TRUE}.}
}
\value{
\code{add_dataset_file} returns the new file ID.
}
\description{
Add or update a file in a dataset
}
\details{
From Dataverse v4.6.1, the \dQuote{native} API provides endpoints to add and update files without going through the SWORD workflow. To use SWORD instead, see \code{\link{add_file}}. \code{add_dataset_file} adds a new file to a specified dataset.

\code{update_dataset_file} can be used to replace/update a published file. Note that it only works on published files, so unpublished drafts cannot be updated - the dataset must first either be published (\code{\link{publish_dataset}}) or deleted (\code{\link{delete_dataset}}).
}
\examples{
\dontrun{
meta <- list()
ds <- create_dataset("mydataverse", body = meta)

saveRDS(mtcars, tmp <- tempfile(fileext = ".rds"))
f <- add_dataset_file(tmp, dataset = ds, description = "mtcars")

# publish dataset
publish_dataset(ds)

# update file and republish
saveRDS(iris, tmp)
update_dataset_file(tmp, dataset = ds, id = f, 
                    description = "Actually iris")
publish_dataset(ds)

# cleanup
unlink(tmp)
delete_dataset(ds)
}
}
\seealso{
\code{\link{get_dataset}}, \code{\link{delete_dataset}}, \code{\link{publish_dataset}}
}
