% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWORD_dataset.R
\name{publish_sword_dataset}
\alias{publish_sword_dataset}
\title{Publish dataset (SWORD)}
\usage{
publish_sword_dataset(
  dataset,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{dataset}{A dataset DOI (or other persistent identifier), an object of class \dQuote{dataset_atom} or \dQuote{dataset_statement}, or an appropriate and complete SWORD URL.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are
multiple Dataverse installations, but the defaults is to use the Harvard
Dataverse (\code{server = "dataverse.harvard.edu"}). This can be modified atomically
or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{...}{Additional arguments passed to an HTTP request function, such as
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}.}
}
\value{
A list.
}
\description{
Publish a SWORD (possibly unpublished) dataset
}
\details{
This function is used to publish a dataset by its persistent identifier. This cannot be undone. The function is part of the SWORD API, which is used to upload data to a Dataverse server.
}
\examples{
\dontrun{
# retrieve your service document
d <- service_document()

# create a list of metadata
metadat <- list(title = "My Study",
                creator = "Doe, John",
                description = "An example study")

# create the dataset in first dataverse
dat <- initiate_sword_dataset(d[[2]], body = metadat)

# publish dataset
publish_sword_dataset(dat)

# delete a dataset
delete_dataset(dat)
}
}
\seealso{
Managing a Dataverse: \code{\link{publish_dataverse}}; Managing a dataset: \code{\link{dataset_atom}}, \code{\link{list_datasets}}, \code{\link{create_dataset}}, \code{\link{delete_sword_dataset}}, \code{\link{publish_dataset}}; Managing files within a dataset: \code{\link{add_file}}, \code{\link{delete_file}}
}
