% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dv_diff.R
\name{read_dv_diff}
\alias{read_dv_diff}
\title{Read dv diff}
\usage{
read_dv_diff(destination, as_of, key_cols)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{as_of}{the valid date at which you'd like to read the dv}

\item{key_cols}{a character vector of column names that constitute a unique key}
}
\value{
a data frame
}
\description{
Read a version of a versioned dataset into a data frame using just the stored diffs.
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
create_dv(df, temp_dir, diffed = TRUE)

read_dv_diff(temp_dir,
             as_of = lubridate::now(),
             key_cols = get_metadata(temp_dir)$key_cols)

unlink(temp_dir)

}
