% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/whos.R
\name{whos}
\alias{whos}
\alias{whos.all}
\title{Display contents of an evironment, data.frame or list as a summary table}
\usage{
whos(envir = parent.frame(), pattern = ".", all.names,
  exclude = getOpt("exclude"))

whos.all(...)
}
\arguments{
\item{envir}{Environment, data frame or list to be displayed. Optional,
default: globalenv()}

\item{pattern}{Regexp filtering of objects. Only objects matching the pattern
are displayed. Optional, default: show all objects.}

\item{all.names}{Whether to show hidden objects.}

\item{exclude}{A list of objects not to be displayed. To set a default exclusion
mask use the \code{whos.set.mask} function. If \code{whos.set.mask} is
called without a list of object names all objects currently in globalenv()
are hidden. This is useful for example if you have a lot of stuff in the
workspace that you aren't currently interested in but is needed to make
your code run.}

\item{...}{Parameters sent to \code{\link{whos}}.}
}
\value{
Nothing

Nothing
}
\description{
Color coded according to class and dimensions of contents. See
\code{\link[xtermStyle]{style}} for details.

Shortcut for calling whos without exclusion.
}
\examples{
whos()
data(USArrests)
whos(USArrests)

data(iris)
whos()
whos.all()
}
\author{
Christofer \enc{Bäcklin}{Backlin}

Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
whos.options, browse
}

