% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_misc.R
\name{object_has_names}
\alias{object_has_names}
\alias{object_has_rownames}
\title{Check names and rownames}
\usage{
object_has_names(x, names)

object_has_rownames(x)
}
\arguments{
\item{x}{A named object (an atomic vector, a list, a dataframe, etc.).}

\item{names}{A single character or a vector of characters.}
}
\value{
A logical or a vector of logicals.
}
\description{
\code{object_has_names()} checks if specified names are present in the given object.
\code{object_has_rownames()} checks if rownames are present in a dataframe.
}
\examples{

# check if specified names are present in the given object
object_has_names(mtcars, "am")
object_has_names(anscombe, c("x1", "z1", "y1"))
object_has_names(list("x" = 1, "y" = 2), c("x", "a"))

# check if a dataframe has rownames
object_has_rownames(mtcars)

}
