% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rescale.R
\name{data_rescale}
\alias{data_rescale}
\alias{change_scale}
\alias{data_rescale.numeric}
\alias{data_rescale.data.frame}
\title{Rescale Variables to a New Range}
\usage{
data_rescale(x, ...)

change_scale(x, ...)

\method{data_rescale}{numeric}(x, to = c(0, 100), range = NULL, verbose = TRUE, ...)

\method{data_rescale}{data.frame}(
  x,
  to = c(0, 100),
  range = NULL,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  ...
)
}
\arguments{
\item{x}{A (grouped) data frame, numeric vector or factor.}

\item{...}{Arguments passed to or from other methods.}

\item{to}{Numeric vector of length 2 giving the new range that the variable will have after rescaling.
To reverse-score a variable, the range should be given with the maximum value first.
See examples.}

\item{range}{Initial (old) range of values. If \code{NULL}, will take the range of
the input vector (\code{range(x)}).}

\item{verbose}{Toggle warnings.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}
}
\value{
A rescaled object.
}
\description{
Rescale variables to a new range.
Can also be used to reverse-score variables (change the keying/scoring direction).
}
\examples{
data_rescale(c(0, 1, 5, -5, -2))
data_rescale(c(0, 1, 5, -5, -2), to = c(-5, 5))
data_rescale(c(1, 2, 3, 4, 5), to = c(-2, 2))

# Specify the "theoretical" range of the input vector
data_rescale(c(1, 3, 4), to = c(0, 40), range = c(0, 4))

# Reverse-score a variable
data_rescale(c(1, 2, 3, 4, 5), to = c(5, 1))
data_rescale(c(1, 2, 3, 4, 5), to = c(2, -2))

# Data frames
head(data_rescale(iris, to = c(0, 1)))
head(data_rescale(iris, to = c(0, 1), select = "Sepal.Length"))

# One can specify a list of ranges
head(data_rescale(iris, to = list(
  "Sepal.Length" = c(0, 1),
  "Petal.Length" = c(-1, 0)
)))
}
\seealso{
Other transform utilities: 
\code{\link{data_reverse}()},
\code{\link{normalize}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
