% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_into.r
\name{recode_into}
\alias{recode_into}
\title{Recode values from one or more variables into a new variable}
\usage{
recode_into(..., data = NULL, default = NA, verbose = TRUE)
}
\arguments{
\item{...}{A sequence of two-sided formulas, where the left hand side (LHS)
is a logical matching condition that determines which values match this case.
The LHS of this formula is also called "recode pattern" (e.g., in messages).
The right hand side (RHS) indicates the replacement value.}

\item{data}{Optional, name of a data frame. This can be used to avoid writing
the data name multiple times in \code{...}. See 'Examples'.}

\item{default}{Indicates the default value that is chosen when no match in
the formulas in \code{...} is found. If not provided, \code{NA} is used as default
value.}

\item{verbose}{Toggle warnings.}
}
\value{
A vector with recoded values.
}
\description{
This functions recodes values from one or more variables into a new variable.
It is a convenient function to avoid nested \code{\link[=ifelse]{ifelse()}} statements, which
is similar to \code{dplyr::case_when()}.
}
\examples{
x <<- 1:30
recode_into(
  x > 15 ~ "a",
  x > 10 & x <= 15 ~ "b",
  default = "c"
)

set.seed(123)
d <<- data.frame(
  x = sample(1:5, 30, TRUE),
  y = sample(letters[1:5], 30, TRUE),
  stringsAsFactors = FALSE
)

# from different variables into new vector
recode_into(
  d$x \%in\% 1:3 & d$y \%in\% c("a", "b") ~ 1,
  d$x > 3 ~ 2,
  default = 0
)

# no need to write name of data frame each time
recode_into(
  x \%in\% 1:3 & y \%in\% c("a", "b") ~ 1,
  x > 3 ~ 2,
  data = d,
  default = 0
)
}
