% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pevs.R
\encoding{UTF-8}
\name{load_pevs}
\alias{load_pevs}
\title{PEVS - Forestry Activities}
\usage{
load_pevs(dataset = NULL, raw_data, geo_level, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("pevs_forest_crops", "pevs_silviculture" or "pevs_silviculture_area"). You can also use SIDRA codes (see \url{https://sidra.ibge.gov.br/pesquisa/pevs/quadros/brasil/2019})}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "region", "state", "mesoregion", "microregion" or "city". See documentation of \code{sidrar}.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} consisting of geographic units that present positive values for any of the variables in the dataset.
}
\description{
Loads information on the amount and value of the production of the exploitation of native plant resources and planted forest massifs, as well as existing total and harvested areas of forest crops. Survey is done at the municipal level and data is available from 1986 to 2019. See \url{https://www.ibge.gov.br/en/statistics/economic/agriculture-forestry-and-fishing/18374-forestry-activities.html?=&t=o-que-e}
}
\examples{
\dontrun{
# download state raw data from 2012 for silviculture
pevs_silvi <- load_pevs(dataset = 'pevs_silviculture',
                        raw_data = TRUE,
                        geo_level = 'state',
                        time_period = 2012)
}
}
