% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibama.R
\name{load_ibama}
\alias{load_ibama}
\title{IBAMA - Brazilian Institute for the Environment and Renewable Natural Resources}
\usage{
load_ibama(dataset, raw_data = FALSE, states = "all", language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("areas_embargadas", "distributed_fines", or "collected_fines")}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{states}{A \code{string} specifying for which states to download the data. It is "all" by default, but can be a single state such as "AC" or any vector such as c("AC", "AM"). Does not apply to the "areas_embargadas" dataset.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads information on environmental fines in the Amazon region
}
\examples{
\dontrun{
# Download treated embargoes data (raw_data = FALSE) in english (language = "eng")
data <- load_ibama(
  dataset = "areas_embargadas", raw_data = FALSE,
  language = "eng"
)

# Download treated collected fines data from "BA"
data <- load_ibama(
  dataset = "collected_fines", raw_data = FALSE,
  states = "BA", language = "pt"
)
}

}
