% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_mrca.R
\name{mrca_calibrations}
\alias{mrca_calibrations}
\title{Identify nodes of a tree topology that are most recent common ancestor (mrca)
of taxon pairs from a \code{calibrations} object}
\usage{
mrca_calibrations(phy, calibrations)
}
\arguments{
\item{phy}{A \code{phylo} object.}

\item{calibrations}{A \code{calibrations} object, an output of
\code{\link[=extract_calibrations_phylo]{extract_calibrations_phylo()}}.}
}
\value{
A list of two elements:
\describe{
\item{matched_phy}{A \code{phylo} object with nodes renamed to match results of
the mrca search. Nodes are renamed using \code{\link[=tree_add_nodelabels]{tree_add_nodelabels()}}.}
\item{matched_calibrations}{A \code{matchedCalibrations} object, which is the input \code{calibrations}
object with two additional columns storing results from the mrca search with
\code{\link[phytools:findMRCA]{phytools::findMRCA()}}: \verb{$mrca_node_number} and \verb{$mrca_node_name}.}
}
}
\description{
\code{mrca_calibrations} get nodes of a tree topology given in
\code{phy} that correspond to the most recent common ancestor (mrca) of taxon
pairs given in \code{calibrations}. It uses \code{\link[phytools:findMRCA]{phytools::findMRCA()}} to get mrca nodes.
}
\details{
The function takes pairs of taxon names in a calibrations data frame,
and looks for them in the vector of tip labels of the tree. If both are present,
then it gets the node that represents the most recent
common ancestor (mrca) for that pair of taxa in the tree.
Nodes of input \code{phy} can be named or not. They will be renamed.
}
