% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy_general.R
\name{tnrs_match}
\alias{tnrs_match}
\alias{tnrs_match.default}
\alias{tnrs_match.phylo}
\title{Taxon name resolution service (tnrs) applied to a vector of names by batches}
\usage{
tnrs_match(input, reference_taxonomy, tip, ...)

\method{tnrs_match}{default}(input, reference_taxonomy = "ott", ...)

\method{tnrs_match}{phylo}(input, reference_taxonomy = "ott", tip = NULL, ...)
}
\arguments{
\item{input}{A character vector of taxon names, or a phylo object with tip names, to be matched to taxonomy.}

\item{reference_taxonomy}{A character vector specifying the reference taxonomy to use for TNRS.
Options are "ott", "ncbi", "gbif" or "irmng". The function defaults to "ott".}

\item{tip}{A vector of mode numeric or character specifying the tips to match. If left empty all tips will be matched.}

\item{...}{
  Arguments passed on to \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names}}
  \describe{
    \item{\code{context_name}}{name of the taxonomic context to be searched (length-one
character vector or \code{NULL}). Must match (case sensitive) one of the
values returned by \code{\link[rotl]{tnrs_contexts}}. Default to "All life".}
    \item{\code{do_approximate_matching}}{A logical indicating whether or not to
perform approximate string (a.k.a. \dQuote{fuzzy}) matching. Using
\code{FALSE} will greatly improve speed. Default, however, is \code{TRUE}.}
    \item{\code{ids}}{A vector of ids to use for identifying names. These will be
assigned to each name in the names array. If ids is provided, then ids and
names must be identical in length.}
    \item{\code{include_suppressed}}{Ordinarily, some quasi-taxa, such as incertae
sedis buckets and other non-OTUs, are suppressed from TNRS results. If
this parameter is true, these quasi-taxa are allowed as possible TNRS
results.}
  }}
}
\value{
An object of class  data frame or phylo, with the added class match_names.

\code{NULL}

\code{NULL}
}
\description{
Taxon name resolution service (tnrs) applied to a vector of names by batches
}
\details{
There is no limit to the number of names that can be queried and matched.

The output will preserve all elements from original input phylo object and will add
\describe{
\item{phy$mapped}{A character vector indicating the state of mapping of phy$tip.labels:}
\describe{
\item{original}{Tnrs matching was not attempted. Original labeling is preserved.}
\item{ott}{Matching was manually made by a curator in Open Tree of Life.}
\item{tnrs}{Tnrs matching was attempted and successful with no approximate matching. Original label is replaced by the matched name.}
\item{approximated}{Tnrs matching was attempted and successful but with approximate matching. Original labeling is preserved.}
\item{unmatched}{Tnrs matching was attempted and unsuccessful. Original labeling is preserved.}
}
\item{phy$original.tip.label}{A character vector preserving all original labels.}
\item{phy$ott_ids}{A numeric vector with ott id numbers of matched tips. Unmatched and original tips will be NaN.}
}
if tips are duplicated, tnrs will only be run once (avoiding increases in function running time) but the result will be applied to all duplicated tip labels
}
\examples{
tnrs_match(input = c("Mus"))
tnrs_match(input = c("Mus", "Mus musculus"))
tnrs_match(input = c("Mus", "Echinus", "Hommo", "Mus"))
}
