% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_summary.R
\name{summarize_datelife_result}
\alias{summarize_datelife_result}
\title{Summarize a \code{datelifeResult} object.}
\usage{
summarize_datelife_result(
  datelife_result = NULL,
  datelife_query = NULL,
  summary_format = "phylo_all",
  na_rm = TRUE,
  summary_print = c("citations", "taxa"),
  taxon_summary = c("none", "summary", "matrix"),
  criterion = "taxa"
)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{datelife_query}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}

\item{summary_format}{A character vector of length one, indicating the output
format for results of the DateLife search. Available output formats are:
\describe{
\item{"citations"}{A character vector of references where chronograms with
some or all of the target taxa are published (source chronograms).}
\item{"mrca"}{A named numeric vector of most recent common ancestor (mrca)
ages of target taxa defined in input, obtained from the source chronograms.
Names of mrca vector are equal to citations.}
\item{"newick_all"}{A named character vector of newick strings corresponding
to target chronograms derived from source chronograms. Names of newick_all
vector are equal to citations.}
\item{"newick_sdm"}{Only if multiple source chronograms are available. A
character vector with a single newick string corresponding to a target
chronogram obtained with SDM supertree method (Criscuolo et al. 2006).}
\item{"newick_median"}{Only if multiple source chronograms are available.
A character vector with a single newick string corresponding to a target
chronogram from the median of all source chronograms.}
\item{"phylo_sdm"}{Only if multiple source chronograms are available. A
phylo object with a single target chronogram obtained with SDM supertree
method (Criscuolo et al. 2006).}
\item{"phylo_median"}{Only if multiple source chronograms are available. A
phylo object with a single target chronogram obtained from source
chronograms with median method.}
\item{"phylo_all"}{A named list of phylo objects corresponding to each target
chronogram obtained from available source chronograms. Names of
phylo_all list correspond to citations.}
\item{"phylo_biggest"}{The chronogram with the most taxa. In the case of a
tie, the chronogram with clade age closest to the median age of the
equally large trees is returned.}
\item{"html"}{A character vector with an html string that can be saved and
then opened in any web browser. It contains a 4 column table with data on
target taxa: mrca, number of taxa, citations of source chronogram and
newick target chronogram.}
\item{"data_frame"}{A 4 column \code{data.frame} with data on target taxa: mrca, number of
taxa, citations of source chronograms and newick string.}
}}

\item{na_rm}{If \code{TRUE}, it drops rows containing \code{NA}s from the \code{datelifeResult}
patristic matrix; if \code{FALSE}, it returns \code{NA} where there are missing entries.}

\item{summary_print}{A character vector specifying the type of summary information
to be printed to screen. Options are:
\describe{
\item{"citations"}{Prints references of chronograms where target taxa are found.}
\item{"taxa"}{Prints a summary of the number of chronograms where each target
taxon is found.}
\item{"none"}{Nothing is printed to screen.}
}
Defaults to \code{c("citations", "taxa")}, which displays both.}

\item{taxon_summary}{A character vector specifying if data on target taxa missing
in source chronograms should be added to the output as a \code{"summary"} or as a
presence/absence \code{"matrix"}. Default to \code{"none"}, no information on taxon_summary
added to the output.}

\item{criterion}{Defaults to \code{criterion = "taxa"}. Used for chronogram summarizing, i.e., obtaining a single
summary chronogram from a group of input chronograms.
For summarizing approaches that return a single summary tree from a group of
phylogenetic trees, it is necessary that the latter form a grove, roughly,
a sufficiently overlapping set of taxa between trees, see Ané et al. (2009) \doi{10.1007/s00026-009-0017-x}.
In rare cases, a group of trees can have multiple groves. This argument indicates
whether to get the grove with the most trees (\code{criterion = "trees"}) or the
most taxa (\code{criterion = "taxa"}).}
}
\value{
The output is determined by the argument \code{summary_format}:
\describe{
\item{If \code{summary_format = "citations"}}{The function returns a character
vector of references.}
\item{If \code{summary_format = "mrca"}}{The function returns a named numeric
vector of most recent common ancestor (mrca) ages.}
\item{If \code{summary_format = "newick_[all, sdm, or median]"}}{The function
returns output chronograms as newick strings.}
\item{If \code{summary_format = "phylo_[all, sdm, median, or biggest]"}}{The
function returns output chronograms as \code{phylo} or \code{multiPhylo} objects.}
\item{If \verb{summary_format = "html" or "data_frame"}}{The function returns a
4 column table with data on mrca ages, number of taxa, references, and output chronograms as newick strings.}
}
}
\description{
Get different types of summaries from a \code{datelifeResult}
object, an output from \code{\link[=get_datelife_result]{get_datelife_result()}}.
This allows rapid processing of data.
If you need a list of chronograms from your \code{datelifeResult} object, this
is the function you are looking for.
}
\references{
Ané, C., Eulenstein, O., Piaggio-Talice, R., & Sanderson, M. J. (2009).
"Groves of phylogenetic trees". Annals of Combinatorics, 13(2), 139-167,
\doi{10.1007/s00026-009-0017-x}.
}
