% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_map_data.R
\name{get_map_data}
\alias{get_map_data}
\title{Fetch map data to use with \code{{sf}}.}
\usage{
get_map_data(type, cache = TRUE, ...)
}
\arguments{
\item{type}{Defines the type of map data to request from DAWA. Run
\code{available_sections(format = "geojson")} to see your options.}

\item{cache}{Boolean to determine whether or not to cache the api call and
the function output. Default is \code{TRUE}.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> input query parameters.}
}
\value{
Returns a \code{data.frame} object that contains polygons (or points) for
the section provided.
}
\description{
This function returns map data from DAWA. It is ready to use
with \code{{sf}} functions. The returned dataframe has date-time columns to inform
when the information was last changed. It is returned in Europe/Copenhagen
time as that is the \emph{local time} for the API. You can change that behavior by
setting \code{Sys.setenv(TZ = "Your/Timezone")}.
}
\examples{
\dontrun{
x <- get_map_data("regioner")
ggplot2::ggplot(x) +
  ggplot2::geom_sf()
}
}
