% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\docType{class}
\name{dbcsp-class}
\alias{dbcsp-class}
\title{S4 class for representing DB-CSP (Distance-Based Common Spatial Patterns)}
\description{
An object of class dbcsp. 'dbcsp' stands for Distance-Based Common Spatial Patterns.
The object includes the Common Spatial Patterns filter obtained with the input lists and
using the distance method indicated.
}
\details{
If the lists of matrices \code{X1} or \code{X2} contain NA values, these are automatically interpolated by a linear interpolation
using \code{\link[zoo]{na.approx}} function. These new interpolated matrices are saved in the X1 and X2 slots of the object.

The supported distances for \code{type} are these ones:
\itemize{
\item Included in \code{\link[=TSDatabaseDistances]{TSdist}}: infnorm, ccor, sts, lb.keogh, edr, erp, lcss, fourier, tquest, dissim, acf, pacf, ar.lpc.ceps, ar.mah,
ar.mah.statistic, ar.mah.pvalue, ar.pic, cdm, cid, cor, cort, int.per, per, mindist.sax, ncd, pred, spec.glk, spec.isd,
spec.llr, pdc, frechet, tam.
\item Included in \code{\link{parallelDist}}: bhjattacharyya, bray, canberra, chord, divergence, dtw, euclidean, fJaccard, geodesic, hellinger,
kullback, mahalanobis, manhattan, maximum, minkowski, podani, soergel, wave, whittaker.
\item It is possible to use a custom distance. The name of the custom distance function is passed as character to the \code{type} parameter.
In order to use the \code{\link{parallelDist}} custom distance option, the custom function must be defined as
explained in "\code{Details: User-defined distance functions}" part of \code{\link{parallelDist}} documentation.
See Examples section below.
}

The additional parameters for the selected distance (see \code{\link[=TSDatabaseDistances]{TSdist}}, \code{\link{parallelDist}}) can be passed
as parameters when creating the object, which will be saved in \code{more} slot. See Examples section below.

The output is a list containing this information (\code{object@out}):
\itemize{
\item \code{vectors} The projection vectors obtained after applying CSP.
\item \code{eig} The eigenvalues obtained after applying CSP.
\item \code{proy} The variance values of the projected signals obtained after applying CSP.
}

And if \code{training=TRUE} the following values are also saved:
\itemize{
\item \code{acc} The mean accuracy value obtained for training data applying cross validation.
\item \code{used_folds} List of the folds used in the cross validation.
\item \code{folds_acc} Accuracy values for each of the folds of the cross validation.
\item \code{model} The trained LDA classifier.
\item \code{selected_q} The number of vectors used when training.
}
}
\section{Slots}{

\describe{
\item{\code{X1}}{list of matrices for data class 1.}

\item{\code{X2}}{list of matrices for data class 2.}

\item{\code{q}}{integer value indicating the number of vectors used in the projection, by default \code{q=15}.}

\item{\code{labels}}{vector of two strings indicating labels names, by default names of variables X1 and X2.}

\item{\code{type}}{string which sets the type of distance to be considered, by default \code{type='EUCL'}. See details section.}

\item{\code{w}}{weight for the distances mixture D_mixture = w*D_euclidean + (1-w)*D_type, by default \code{w=0.5}.}

\item{\code{mixture}}{logical value indicating whether to use distances mixture or not (EUCL + other), by default \code{mixture=FALSE}.}

\item{\code{training}}{logical value indicating whether to perform the training or not.}

\item{\code{fold}}{integer value, by default \code{fold=10}. It controls the number of partitions when training.
If \code{fold==1} a train/test split is performed, with p=0.2 for test indices.}

\item{\code{seed}}{numeric value, by default \code{seed=NULL}. Set a seed to ensure reproducible results.}

\item{\code{eig.tol}}{numeric value, by default \code{eig.tol=1e-06}, tolerance to convert distance matrix to be definite positive.}

\item{\code{verbose}}{logical}

\item{\code{more}}{list, additional parameters to be passed to the distance methods. See details section.}

\item{\code{out}}{list containing the output.}
}}

\examples{
# To create an instance of a class dbcsp given data from 2 classes
x <- AR.data$come[1:20]
y <- AR.data$five[1:20]
mydbcsp <- new("dbcsp", X1 = x, X2 = y)

# CUSTOM DISTANCE
x <- AR.data$come[1:10]
y <- AR.data$five[1:10]
fn <- function(x, y, eps=1) mean(1 - cos(x - y))*eps
mydbcsp <- new("dbcsp", X1 = x, X2 = y, type="fn", eps=0.9)

}
\seealso{
\code{\link[=dbcsp-package]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link[=train.dbcsp]{train}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
