\name{db}
\alias{dbd}
\alias{ddb}
\alias{pdb}
\alias{qdb}
\alias{rdb}
\title{
    The db (\dQuote{discretised Beta}) distribution.
}
\description{
Density, distribution function, quantile function and random generation for the db
distribution with parameters \code{alpha}, \code{beta} and \code{ntop}.
}
\usage{
ddb(x, alpha, beta, ntop, zeta=FALSE, log=FALSE)
pdb(x, alpha, beta, ntop, zeta=FALSE)
qdb(p, alpha, beta, ntop, zeta=FALSE)
rdb(n, alpha, beta, ntop, zeta=FALSE)
}
\arguments{
  \item{x}{
  Numeric vector of values at which the \dQuote{density} (probability
  mass function) \code{ddb()} and the cumulative distribution
  function \code{pdb()} are evaluated.  Normally these would be
  integer values between \code{nbot} and \code{ntop}, but they need
  not be.  Note that \code{nbot} is 0 if \code{zeta} is \code{TRUE},
  and is 1 if \code{zeta} is \code{FALSE}.  A result of 0 is returned
  by \code{ddb()} for values of \code{x} that do not satisfy the
  foregoing criterion.  A warning is issued by \code{ddb()} if any
  of the values in \code{x} are non-integer.  See section \bold{Note}
  for a little more information.  Missing values (\code{NA}) are
  allowed; the corresponding results are \code{NA}.
}
  \item{alpha}{
  Positive scalar.  The first \dQuote{shape} parameter of the
  db distribution.
}
  \item{beta}{
  Positive scalar.  The second \dQuote{shape} parameter of the
  db distribution.
}
  \item{ntop}{
  Integer scalar, strictly greater than 1.  The maximum possible
  value of the db distribution.
}
  \item{zeta}{
  Logical scalar.  Should zero origin indexing be used?
  I.e. should the range of values of the distribution be taken to
  be \code{{0,1,2,...,ntop}} rather than \code{{1,2,...,ntop}}?
  Setting \code{zeta=TRUE} may be useful for example when the values
  of the distribution are to be interpreted as counts.
}
  \item{log}{
  Logical scalar.  Should logs of the probabilities calculated by
  \code{ddb()} be returned, rather than the actual probabilities?
}
  \item{p}{
  Vector of probablilities (i.e. values between 0 and 1).  The
  corresponding quantiles of the db distribution are calculated
  by \code{qdb()}.  Missing values (\code{NA}) are allowed.
}
  \item{n}{
  Integer scalar.  An independent sample of size \code{n} from the
  db distribution is generated by \code{rdb()}.
}
}

\details{
In the predecessor of this package (\code{hse} versions 0.1-15
and earlier), the probability function of the distribution
was calculated as \code{dbeta(x/(ntop+1),alpha,beta)/
sum(dbeta((nbot:ntop)/(ntop+k),alpha,beta))} where \code{nbot}
and \code{k} were set to 1 if \code{zeta} was \code{FALSE},
and \code{nbot} was set to 0 and \code{k} to 2 if \code{zeta}
was \code{TRUE}.

However the probability function is calculated in a more
\dQuote{direct} manner, using an exponential family representation
of this function.  The \code{Beta} distribution is no longer called
upon (although it still of course conceptually underlies the
distribution).

The function \code{ddb()} is a probability mass function for
an ad hoc finite discrete distribution of \emph{ordered} values,
with a \dQuote{reasonably flexible} shape.

The \eqn{p}th quantile of a random variable \eqn{X} is defined to be
the infimum \emph{over the range of} \eqn{X} of those values of \eqn{x}
such that \eqn{F(x) \geq p}{F(x) >= p} where \eqn{F(x)} is the cumulative
distribution function for \eqn{X}.  Note that if we did not impose the
\dQuote{over the range of \eqn{X}} restriction, then the 0th quantile of
e.g. an exponential distribution would be \eqn{-\infty}{\code{-Inf}}
(since \eqn{F(x) \geq 0}{F(x) >= 0} for \emph{all} \eqn{x}) whereas we
actually want this quantile to be 0.

Consequently \code{qdb(p,alpha,beta,ntop)} is equal to the
least value of \code{i} such that \code{pdb(i,alpha,beta,ntop)}
\eqn{\geq}{>=} \code{p}.  The set of values of \code{i} to be
considered is \code{{1,2,...,ntop}} if \code{zeta} is
\code{FALSE} and is \code{{0,1,2,...,ntop}} if \code{zeta}
is \code{TRUE}.

}

\section{Note}{
In the predecessor of this package (\code{hse}, versions 0.1-14
and earlier) the density/probability function threw an error if
any values of argument \code{i} were not in the set of integers
\code{nbot:ntop}.  In accordance with a suggestion from Duncan
Murdoch this behaviour was changed so that the density/probability
function returns 0 for such values.  It also issues a warning
if any of the values are non-integer.  The criterion used
for \dQuote{non-integer} is that \code{abs(i-round(i)) >
sqrt(.Machine$double.eps)}.  The new behaviour is analogous to
that of other probability functions used in R, \code{dbinom()}
in particular.
}

\value{
\itemize{
\item For \code{ddb()} and \code{pdb()} vectors of probabilities.
\item For \code{qdb()} a vector of quantiles.
\item For \code{rdb()} a vector of length \code{n}, of integers
      between \code{nbot} and \code{ntop}, independently sampled
      from the db distribution, where \code{nbot} is 1 if
      \code{zeta} is \code{FALSE} and is 0 if \code{zeta}
      is \code{TRUE}.
}
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}

\seealso{
   \code{\link{meDb}()}
   \code{\link{mleDb}()}
}
\examples{
parz <- list(c(0.5,0.5),c(5,1),c(1,3),c(2,2),c(2,5))
for(i in 1:5) {
    p1 <- ddb(1:15,parz[[i]][1],parz[[i]][2],15)
    names(p1) <- 1:15
    eckslab <- paste0("alpha=",parz[[i]][1]," beta=",parz[[i]][2])
    barplot(p1,xlab=eckslab,main="db probabilities",
            space=1.5,col="black")
    abline(h=0)
    if(i < 5) readline("Go? ")
}
x <- c(-1.5,-1,-0.5,0,0.5,1,1.5)
ddb(x,2.5,1,5,TRUE) # Produces 0 for all but the 4th and 6th
                    # entries of x, and issues a warning, as it should.
}
\keyword{ distribution }
