% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_common_utilities.R
\name{open_db}
\alias{open_db}
\title{Establish connection to given data base}
\usage{
open_db(driver, server, output_database, trusted_connection = TRUE)
}
\arguments{
\item{driver}{odbc object to define database driver.}

\item{server}{string, indicated the db server name.}

\item{output_database}{string, the database name to be used,
it has to be created before using it}

\item{trusted_connection}{boolean, is the connection secure}
}
\value{
sets the open connection in memory to be used by other functions
}
\description{
\code{open_db} opens connection to given database.
}
\details{
This function establishes connection to given database
to store, \emph{optionally}, the parsed drug bank elements.
}
\examples{
\donttest{
open_db(xml_db_name =  "drugbank.xml", driver = "SQL Server",
server = "MOHAMMED\\\\\\\\SQL2016", output_database = "drugbank2")
}
}
