% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{drug_salts}
\alias{drug_salts}
\title{Drug Salts parser}
\usage{
drug_salts()
}
\value{
a tibble with 1 variables:
\describe{
 \item{drugbank-id}{DrugBank identifiers of the available salt form(s).}
 \item{name}{Name of the available salt form(s)}
 \item{unii}{Unique Ingredient Identifier (UNII) of the available salt
 form(s).}
 \item{cas-number}{Chemical Abstracts Service (CAS) registry number assigned
  to the salt form(s) of the drug.}
 \item{inchikey}{IUPAC International Chemical Identifier (InChi) key
 identifier for the available salt form(s).}
 \item{average-mass}{Average molecular mass: the weighted average of the
  isotopic masses of the salt.}
 \item{monoisotopic-mass}{The mass of the most abundant isotope of the salt}
 \item{smiles}{The simplified molecular-input line-entry system (SMILES) is
 a line notation used for describing the structure of chemical species using
  short ASCII strings; calculated by ChemAxon.}
 \item{inchi}{A prediction of the IUPAC
 International Chemical Identifier (InChI); imported by ChemAxon.}
 \item{formula}{Indicates the simple numbers of each type of atom within the
  molecule; calculated by ChemAxon.}
 \item{\emph{drugbank_id}}{parent drugbank id}
}
}
\description{
Available salt forms of the drug. Ions such as hydrochloride, sodium,
 and sulfate are often added to the drug molecule to increase solubility,
 dissolution, or absorption.
}
\keyword{internal}
